/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.commands;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.util.TriPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.server.command.CommandTreeBase;

public class ConvertCommand
extends CommandTreeBase {
    public ConvertCommand() {
        this.addSubcommand((ICommand)new SetCommand());
        this.addSubcommand((ICommand)new FillCommand());
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "convert";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/securitycraft convert <set|fill>";
    }

    private static enum ConversionMode {
        REINFORCE((state, level, pos) -> {
            Block block = state.func_177230_c();
            if (IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.containsKey(block)) {
                level.func_175656_a(pos, ((IReinforcedBlock)IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.get(block)).convertToReinforcedState((IBlockState)state));
                return true;
            }
            return false;
        }),
        UNREINFORCE((state, level, pos) -> {
            Block block = state.func_177230_c();
            if (block instanceof IReinforcedBlock) {
                try {
                    level.func_175656_a(pos, ((IReinforcedBlock)block).convertToVanillaState((IBlockState)state));
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
                return true;
            }
            return false;
        }),
        PASSCODE_PROTECT((state, level, pos) -> {
            for (IPasscodeConvertible convertible : SecurityCraftAPI.getRegisteredPasscodeConvertibles()) {
                if (!convertible.isUnprotectedBlock((IBlockState)state)) continue;
                return convertible.protect(null, (World)level, (BlockPos)pos);
            }
            return false;
        }),
        REMOVE_PASSCODE_PROTECTION((state, level, pos) -> {
            for (IPasscodeConvertible convertible : SecurityCraftAPI.getRegisteredPasscodeConvertibles()) {
                if (!convertible.isProtectedBlock((IBlockState)state)) continue;
                return convertible.unprotect(null, (World)level, (BlockPos)pos);
            }
            return false;
        });

        private final TriPredicate<IBlockState, World, BlockPos> converter;

        private ConversionMode(TriPredicate<IBlockState, World, BlockPos> converter) {
            this.converter = converter;
        }

        public boolean convert(IBlockState state, World level, BlockPos pos) {
            return this.converter.test(state, level, pos);
        }
    }

    private static class FillCommand
    extends CommandBase {
        private FillCommand() {
        }

        public String func_71517_b() {
            return "fill";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/securitycraft convert fill <reinforce|unreinforce|passcode_protect|remove_passcode_protection> <x1> <y1> <z1> <x2> <y2> <z2>";
        }

        public int func_82362_a() {
            return 2;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            ConversionMode mode;
            if (args.length < 7) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            World world = sender.func_130014_f_();
            BlockPos firstPosArgs = FillCommand.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)false);
            BlockPos secondPosArgs = FillCommand.func_175757_a((ICommandSender)sender, (String[])args, (int)4, (boolean)false);
            BlockPos from = new BlockPos(Math.min(firstPosArgs.func_177958_n(), secondPosArgs.func_177958_n()), Math.min(firstPosArgs.func_177956_o(), secondPosArgs.func_177956_o()), Math.min(firstPosArgs.func_177952_p(), secondPosArgs.func_177952_p()));
            BlockPos to = new BlockPos(Math.max(firstPosArgs.func_177958_n(), secondPosArgs.func_177958_n()), Math.max(firstPosArgs.func_177956_o(), secondPosArgs.func_177956_o()), Math.max(firstPosArgs.func_177952_p(), secondPosArgs.func_177952_p()));
            int size = (to.func_177958_n() - from.func_177958_n() + 1) * (to.func_177956_o() - from.func_177956_o() + 1) * (to.func_177952_p() - from.func_177952_p() + 1);
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, 0);
            if (size > 32768) {
                throw new CommandException("commands.fill.tooManyBlocks", new Object[]{size, 32768});
            }
            if (from.func_177956_o() < 0 || to.func_177956_o() > 255) {
                throw new CommandException("commands.fill.outOfWorld", new Object[0]);
            }
            try {
                mode = Enum.valueOf(ConversionMode.class, args[0].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            for (int z = from.func_177952_p(); z <= to.func_177952_p(); z += 16) {
                for (int x = from.func_177958_n(); x <= to.func_177958_n(); x += 16) {
                    if (world.func_175667_e(new BlockPos(x, to.func_177956_o() - from.func_177956_o(), z))) continue;
                    throw new CommandException("commands.fill.outOfWorld", new Object[0]);
                }
            }
            int blocksModified = 0;
            for (int z = from.func_177952_p(); z <= to.func_177952_p(); ++z) {
                for (int y = from.func_177956_o(); y <= to.func_177956_o(); ++y) {
                    for (int x = from.func_177958_n(); x <= to.func_177958_n(); ++x) {
                        BlockPos pos = new BlockPos(x, y, z);
                        if (!mode.convert(world.func_180495_p(pos), world, pos)) continue;
                        ++blocksModified;
                    }
                }
            }
            if (blocksModified == 0) {
                throw new CommandException("commands.securitycraft.convert.fill.failed", new Object[0]);
            }
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, blocksModified);
            FillCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.securitycraft.convert.fill.success", (Object[])new Object[]{blocksModified});
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
            if (args.length == 1) {
                return FillCommand.func_71530_a((String[])args, (String[])new String[]{"reinforce", "unreinforce", "passcode_protect", "remove_passcode_protection"});
            }
            if (args.length >= 2 && args.length <= 4) {
                return FillCommand.func_175771_a((String[])args, (int)1, (BlockPos)targetPos);
            }
            if (args.length >= 5 && args.length <= 7) {
                return FillCommand.func_175771_a((String[])args, (int)4, (BlockPos)targetPos);
            }
            return new ArrayList<String>();
        }
    }

    private static class SetCommand
    extends CommandBase {
        private SetCommand() {
        }

        public String func_71517_b() {
            return "set";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/securitycraft convert set <reinforce|unreinforce|passcode_protect|remove_passcode_protection> <x> <y> <z>";
        }

        public int func_82362_a() {
            return 2;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            ConversionMode mode;
            if (args.length < 4) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, 0);
            World world = sender.func_130014_f_();
            BlockPos pos = SetCommand.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)false);
            try {
                mode = Enum.valueOf(ConversionMode.class, args[0]);
            }
            catch (IllegalArgumentException e) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            if (!world.func_175667_e(pos)) {
                throw new CommandException("commands.setblock.outOfWorld", new Object[0]);
            }
            if (!mode.convert(world.func_180495_p(pos), world, pos)) {
                throw new CommandException("commands.securitycraft.convert.set.failed", new Object[0]);
            }
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_BLOCKS, 1);
            SetCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.securitycraft.convert.set.success", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
            if (args.length == 1) {
                return SetCommand.func_71530_a((String[])args, (String[])new String[]{"reinforce", "unreinforce", "passcode_protect", "remove_passcode_protection"});
            }
            if (args.length >= 2 && args.length <= 4) {
                return SetCommand.func_175771_a((String[])args, (int)1, (BlockPos)targetPos);
            }
            return new ArrayList<String>();
        }
    }
}

